-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema pruebas
--

-- CREATE DATABASE IF NOT EXISTS pruebas;
-- USE pruebas;


--
-- Definition of table `incidente_tipo`
--

DROP TABLE IF EXISTS `incidente_tipo`;
CREATE TABLE `incidente_tipo` (
  `id_incidente_tipo` int(11) NOT NULL AUTO_INCREMENT,
  `titulo` varchar(50) NOT NULL,
  `color` varchar(7) NOT NULL,
  PRIMARY KEY (`id_incidente_tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `incidente_tipo`
--

/*!40000 ALTER TABLE `incidente_tipo` DISABLE KEYS */;
INSERT INTO `incidente_tipo` (`id_incidente_tipo`,`titulo`,`color`) VALUES 
 (1,'Permiso (enfermedad)','#3EED13'),
 (2,'Permiso (por estudios)','#1D35ED'),
 (3,'Permiso (legal - otros)','#F038BC'),
 (4,'Permiso (compensación horarios)','#E8E107'),
 (5,'Vacaciones','#17EBD2');
/*!40000 ALTER TABLE `incidente_tipo` ENABLE KEYS */;


--
-- Definition of table `incidente_usuario`
--

DROP TABLE IF EXISTS `incidente_usuario`;
CREATE TABLE `incidente_usuario` (
  `id_incidente_usuario` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(12) NOT NULL,
  `nombre_apellidos` varchar(100) NOT NULL,
  PRIMARY KEY (`id_incidente_usuario`),
  UNIQUE KEY `login_UNIQUE` (`login`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `incidente_usuario`
--

/*!40000 ALTER TABLE `incidente_usuario` DISABLE KEYS */;
INSERT INTO `incidente_usuario` (`id_incidente_usuario`,`login`,`nombre_apellidos`) VALUES 
 (1,'humanes','Fernando Humanes'),
 (2,'admin','Administrador'),
 (3,'user1','Usuario 1');
/*!40000 ALTER TABLE `incidente_usuario` ENABLE KEYS */;

--
-- Definition of table `incidente_caso`
--

DROP TABLE IF EXISTS `incidente_caso`;
CREATE TABLE `incidente_caso` (
  `id_incidente_caso` int(11) NOT NULL AUTO_INCREMENT,
  `incidente_usuario_id` int(11) NOT NULL,
  `incidente_tipo_id` int(11) NOT NULL,
  `fechaDesde` date NOT NULL,
  `fechaHasta` date NOT NULL,
  `titulo` varchar(50) NOT NULL,
  `descripcion` varchar(500) DEFAULT NULL,
  `diasLaborables` int(10) unsigned DEFAULT NULL,
  `diasFinSemana` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id_incidente_caso`),
  KEY `fk_incidente_caso_incidente_usuario_idx` (`incidente_usuario_id`),
  KEY `fk_incidente_caso_incidente_tipo1_idx` (`incidente_tipo_id`),
  CONSTRAINT `fk_incidente_caso_incidente_tipo1` FOREIGN KEY (`incidente_tipo_id`) REFERENCES `incidente_tipo` (`id_incidente_tipo`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_incidente_caso_incidente_usuario` FOREIGN KEY (`incidente_usuario_id`) REFERENCES `incidente_usuario` (`id_incidente_usuario`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `incidente_caso`
--

/*!40000 ALTER TABLE `incidente_caso` DISABLE KEYS */;
INSERT INTO `incidente_caso` (`id_incidente_caso`,`incidente_usuario_id`,`incidente_tipo_id`,`fechaDesde`,`fechaHasta`,`titulo`,`descripcion`,`diasLaborables`,`diasFinSemana`) VALUES 
 (1,2,5,'2023-06-23','2023-06-28','Vacaciones ?','',4,1),
 (2,2,1,'2023-06-27','2023-06-27','Gripe','',1,0),
 (3,1,5,'2023-06-06','2023-06-30','Vacaciones estivales','',19,5),
 (4,1,1,'2023-07-03','2023-07-04','Enfermedad','',2,0),
 (5,3,5,'2023-06-01','2023-06-30','.','',22,7),
 (6,3,2,'2023-07-03','2023-07-04','.','',2,0),
 (7,1,3,'2023-07-05','2023-07-06','Exámenes','.',2,0),
 (10,1,4,'2023-07-13','2023-07-14','Compensación','',2,0);
/*!40000 ALTER TABLE `incidente_caso` ENABLE KEYS */;

--
-- Definition of function `workdaydiff`
--

DROP FUNCTION IF EXISTS `workdaydiff`;

DELIMITER $$

/*!50003 SET @TEMP_SQL_MODE=@@SQL_MODE, SQL_MODE='STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ $$
CREATE  FUNCTION `workdaydiff`(b date, a date) RETURNS int(11)
    DETERMINISTIC
    COMMENT 'working day difference for 2 dates'
BEGIN

DECLARE freedays int;

SET freedays = 0;
SET @x = DATEDIFF(b, a);
IF @x<0 THEN
SET @m = a;
SET a = b;
SET b = @m;
SET @m = -1;
ELSE
SET @m = 1;
END IF;
SET @x = abs(@x) + 1;

SET @w1 = WEEKDAY(a)+1;
SET @wx1 = 8-@w1;
IF @w1>5 THEN
SET @w1 = 0;
ELSE
SET @w1 = 6-@w1;
END IF;
 
SET @wx2 = WEEKDAY(b)+1;
SET @w2 = @wx2;
IF @w2>5 THEN
SET @w2 = 5;
END IF;

SET @weeks = (@x-@wx1-@wx2)/7;
SET @noweekends = (@weeks*5)+@w1+@w2;

SET @result = @noweekends-freedays;
RETURN @result*@m;
END $$
/*!50003 SET SESSION SQL_MODE=@TEMP_SQL_MODE */  $$

DELIMITER ;



/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
